using System;

namespace CSharpRecipes
{
	public class UnsafeCode
    {
        #region 19.1 Kontrolowanie zmian we wskanikach przekazywanych do metod
        public static unsafe void ControlChangesPointers()
        {
            TestSwitchXY();

            int x = 5;
            int* ptrx = &x;
            // wywoanie metody i przekazanie do niej ptrx
            CallByValue(ptrx);

            // wywoanie metody i przekazanie wskanika przez odwoanie
            CallByRef(ref ptrx);

            CallUsingOut(out ptrx);

            Console.WriteLine(*ptrx + "\t" + (int)ptrx);

        }

        public static unsafe void CallUsingOut(out int* ptrx)
        {
            int x = 7;
            ptrx = &x;
        }

        private static unsafe void CallByRef(ref int* x)
        {
            int newNum = 7;
            x = &newNum;
        }

        private static unsafe void CallByValue(int* x)
        {
            int newNum = 7;
            x = &newNum;
        }

        private static unsafe void TestSwitchXY()
        {
            int x = 100;
            int y = 20;
            int* ptrx = &x;
            int* ptry = &y;

            Console.WriteLine(*ptrx + "\t" + (int)ptrx);
            Console.WriteLine(*ptry + "\t" + (int)ptry);

            SwitchXY(ref ptrx, ref ptry);

            Console.WriteLine(*ptrx + "\t" + (int)ptrx);
            Console.WriteLine(*ptry + "\t" + (int)ptry);
        }

        private static unsafe void SwitchXY(ref int* x, ref int* y)
        {
            int* temp = x;
            x = y;
            y = temp;
        }
        #endregion

        #region 19.2 Porwnywanie wskanikw
        public static void ComparePointers()
        {
            unsafe 
            {
                int[] arr = new int[5] {1,2,3,4,5};
                fixed(int* ptrArr = &arr[0])
                {
                    int* p1 = (ptrArr + 1);
                    int* p2 = (ptrArr + 3);

                    Console.WriteLine("p2 > p1");
                    Console.WriteLine("(p2 == p1) = " + (p2 == p1));
                    Console.WriteLine("(p2 != p1) = " + (p2 != p1));

                    p2 = p1;
                    Console.WriteLine("p2 == p1");
                    Console.WriteLine("(p2 == p1) = " + (p2 == p1));
                    Console.WriteLine("(p2 != p1) = " + (p2 != p1));
                }
            }

            unsafe 
            {
                int[] arr = new int[5] {1,2,3,4,5};
                fixed(int* ptrArr = &arr[0])
                {
                    int* p1 = (ptrArr + 1);
                    int* p2 = (ptrArr + 3);

                    Console.WriteLine("p2 > p1");
                    Console.WriteLine("(p2 > p1) = " + (p2 > p1));
                    Console.WriteLine("(p2 < p1) = " + (p2 < p1));
                    Console.WriteLine("(p2 >= p1) = " + (p2 >= p1));
                    Console.WriteLine("(p2 <= p1) = " + (p2 <= p1));

                    p2 = p1;
                    Console.WriteLine("p2 == p1");
                    Console.WriteLine("(p2 > p1) = " + (p2 > p1));
                    Console.WriteLine("(p2 < p1) = " + (p2 < p1));
                    Console.WriteLine("(p2 >= p1) = " + (p2 >= p1));
                    Console.WriteLine("(p2 <= p1) = " + (p2 <= p1));
                }
            }
        
        }
        #endregion

        #region 19.3 Nawigowanie w tablicach
        public static void NavigatingArrays()
        {
            unsafe
            {
                int[] intArray = new int[5] {1, 2, 3, 4, 5};
                fixed(int* arrayPtr = &intArray[0])
                {
                    Console.WriteLine(*(arrayPtr + 4)); // wywietlenie ostatniej wartoci '5'
                }
            }

            unsafe
            {
                Colors[] intArray = new Colors[2] {Colors.Czerwony, Colors.Niebieski};
                fixed(Colors* arrayPtr = &intArray[0])
                {
                    // uycie arrayPtr
                    Console.WriteLine(*(arrayPtr + intArray.GetLength(0) - 1));
                }
            }

            unsafe
            {
                int[,] intMultiArray = new int[2,5] {{1,2,3,4,5},{6,7,8,9,10}};
                fixed(int* arrayPtr = &intMultiArray[0,0])
                {
                    Console.WriteLine(*(arrayPtr + 9)); // wywietlenie ostatniej wartoci '10'
                }
            }

            unsafe
            { 
                int[][] intJaggedArray = new int[3][];
                intJaggedArray[0] = new int[2] {100,200};
                intJaggedArray[1] = new int[3] {300,400,500};
                intJaggedArray[2] = new int[4] {600,700,800,900};
                fixed(int* arrayPtr = &intJaggedArray[0][0])
                {
                    for(int counter = -3; counter <= 15; counter++)
                    {
                        Console.WriteLine(*(arrayPtr + counter)); 
                    }
                }
            }

            unsafe
            { 
                int[][,] intJaggedArray2 = new int[3][,];
                intJaggedArray2[0] = new int[2,1] {{100},{200}};
                intJaggedArray2[1] = new int[3,1] {{300},{400},{500}};
                intJaggedArray2[2] = new int[4,1] {{600},{700},{800},{900}};
                fixed(int* arrayPtr = &intJaggedArray2[0][0,0])
                {
                    for(int counter = -5; counter <= 23; counter++)
                    {
                        Console.WriteLine(*(arrayPtr + counter)); 
                    }
                }
            }

        }

        public enum Colors{Czerwony, Zielony, Niebieski}

        #endregion

        #region 19.4 Operacje na wskaniku do staej tablicy
        public static void ManipulatePointerFixedArray()
        {
            unsafe
            {
                int[] intArray = new int[5] {1,2,3,4,5};
                fixed(int* arrayPtr = &intArray[0])
                {
                    int* tempPtr = arrayPtr;
                    tempPtr++;
                }
            }
        }
        #endregion

        #region 19.5 Zwracanie wskanika do konkretnego elementu tablicy
        public static void RetPtrArrayElement()
        {
            TestFind();
        }

        public static void TestFind()
        {
            unsafe
            {
                int[] numericArr = new int[3] {2,4,6};
                fixed(int* ptrArr = &numericArr[0])
                {
                    int foundPos = FindInFixedArray(ptrArr, numericArr.Length, 4);
                    if (foundPos > -1)
                    {
                        Console.WriteLine("Pozycja w tablicy: " + foundPos);
                    }
                    else
                    {
                        Console.WriteLine("Nie znaleziono");
                    }
                }
            }
        }

        public static unsafe int FindInFixedArray(int* theArray, int arrayLength, int valueToFind)
        {
            for (int counter = 0; counter < arrayLength; counter++)
            {
                if (theArray[counter] == valueToFind)
                {
                    return (counter);
                }
            }

            // zwraca -1, jeli w tablicy nie znaleziono wartoci
            return (-1);
        }

        #endregion

        #region 19.6 Tworzenie i uywanie tablicy wskanikw
        public struct NewBrush
        {
            public int BrushType;
        }

        public static void CreateUseArrayPtrs()
        {
            unsafe
            {
                NewBrush theNewBrush1 = new NewBrush();
                NewBrush theNewBrush2 = new NewBrush();
                NewBrush theNewBrush3 = new NewBrush();

                NewBrush*[] arrayOfNewBrushPtrs = new NewBrush*[3];
                for (int counter = 0; counter < 3; counter++)
                {
                    arrayOfNewBrushPtrs[counter] = null;
                }

                arrayOfNewBrushPtrs[0] = &theNewBrush1;
                arrayOfNewBrushPtrs[1] = &theNewBrush2;
                arrayOfNewBrushPtrs[2] = &theNewBrush3;

                fixed(NewBrush** ptrArrayOfNewBrushPtrs = arrayOfNewBrushPtrs)
                {
                    for (int counter = 0; counter < 3; counter++)
                    {
                        ptrArrayOfNewBrushPtrs[counter]->BrushType = counter;
                        Console.WriteLine(ptrArrayOfNewBrushPtrs[counter]->BrushType);
                        Console.WriteLine((int)ptrArrayOfNewBrushPtrs[counter]);
                    }
                }
            }

        }

        #endregion

        #region 19.7 Zamiana nieznanych typw wskanikw
        public static unsafe void SwitchUnknownPtr()
        {
            int x = 100;
            int y = 20;
            int* ptrx = &x;
            int* ptry = &y;

            Console.WriteLine(*ptrx + "\t" + (int)ptrx);
            Console.WriteLine(*ptry + "\t" + (int)ptry);

            // przeksztacenie int* w void*
            void* voidx = (void*)ptrx;
            void* voidy = (void*)ptry;

            // zamiana wartoci wskanikw
            Switch(ref voidx, ref voidy);

            // przeksztacenie zwrconych wskanikw void* w przydatne wskaniki int*
            ptrx = (int*)voidx;
            ptry = (int*)voidy;

            Console.WriteLine(*ptrx + "\t" + (int)ptrx);
            Console.WriteLine(*ptry + "\t" + (int)ptry);

            byte bx = 100;
            byte by = 20;
            byte* ptrbx = &bx;
            byte* ptrby = &by;

            Console.WriteLine(*ptrbx + "\t" + (int)ptrbx);
            Console.WriteLine(*ptrby + "\t" + (int)ptrby);

            // przeksztacenie byte* w void*
            void* voidbx = (void*)ptrbx;
            void* voidby = (void*)ptrby;

            // przeczenie wartoci wskanikw
            Switch(ref voidbx, ref voidby);

            // przeksztacenie zwrconych wskanikw void* w przydatne wskaniki byte*
            ptrbx = (byte*)voidbx;
            ptrby = (byte*)voidby;

            Console.WriteLine(*ptrbx + "\t" + (int)ptrbx);
            Console.WriteLine(*ptrby + "\t" + (int)ptrby);

        }

        public static unsafe void Switch(ref void* x, ref void* y)
        {
            void* temp = x;
            x = y;
            y = temp;
        }

        #endregion

        #region 19.8 Przeksztacanie cigu znakw w char*
        public static void TestConvertStringToCharPtr()
		{
			ConvertStringToCharPtr("Testowy cig znakw");
		}
		
		public static void ConvertStringToCharPtr(string str)
		{
			unsafe 
			{
				fixed (char* pStr = str.ToCharArray())
				{
					// wywietlenie niektrych znakw
					Console.WriteLine(pStr->ToString());
					Console.WriteLine(pStr[1].ToString());
					Console.WriteLine(pStr[2].ToString());
					Console.WriteLine(pStr[3].ToString());
				}
			}
		}
		#endregion

        #region 19.9 Deklarowanie struktury o staym rozmiarze z osadzon tablic
        public static unsafe void TestEmbeddedFixedArray()
		{
			// utworzenie niezabezpieczonej struktury zawierajcej tablic byte o staym rozmiarze
			UnsafeByteArray ba = new UnsafeByteArray();
			
			// zainicjowanie tablicy bajtw Data
			for (byte i = 0; i <= (byte)254; i++)
				ba.Data[i] = i;

			// wywietlenie wartoci z tablicy Data
			Console.WriteLine(ba.Data[0].ToString());
			Console.WriteLine(ba.Data[2].ToString());
			Console.WriteLine(ba.Data[253].ToString());
			Console.WriteLine(ba.Data[254].ToString());
			
			Console.WriteLine("sizeof(UnsafeByteArray) == " + sizeof(UnsafeByteArray));
		}
		

		public unsafe struct UnsafeByteArray
		{
			public fixed byte Data[254];
		}
		
		public struct SafeByteArray
		{
			public SafeByteArray(int size)
			{
				// utworzenie nowej tablicy byte
				Data = new byte[254];
			}
			
			public byte[] Data;
		}
		#endregion
	}
}
